/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen.dialog;

import com.iafenvoy.jupiter.config.interfaces.ConfigEntry;
import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.dialog.Dialog;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractListDialog<T, S>
extends Dialog<T> {
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    protected final List<WidgetBuilder<S>> widgets = new ArrayList<WidgetBuilder<S>>();
    private int configPerPage;

    protected AbstractListDialog(class_437 parent, TitleStack titleStack, ConfigMetaProvider provider, ConfigEntry<T> entry) {
        super(parent, titleStack, provider, entry);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)JupiterScreen.createButton(10, 5, 20, 20, (class_2561)TextUtil.literal("<"), button -> this.method_25419()));
        this.method_37063((class_364)JupiterScreen.createButton(this.field_22789 - 80, 5, 20, 20, (class_2561)TextUtil.literal("+"), button -> {
            this.addNewValue();
            this.method_41843();
        }));
        this.calculateMaxItems();
        this.widgets.clear();
        List<S> values = this.getValues().stream().toList();
        for (int i = 0; i < values.size(); ++i) {
            WidgetBuilder<S> widget = WidgetBuilderManager.get(this.provider, this.newSingleInstance(values.get(i), i, () -> this.method_41843()));
            this.widgets.add(widget);
            widget.addDialogElements(new WidgetBuilder.Context(this, x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            }, this.titleStack), i + ":", 40, 0, Math.max(10, this.field_22789 - 70), 20);
        }
        this.updateItemPos();
    }

    protected abstract void addNewValue();

    protected abstract Collection<S> getValues();

    protected abstract ConfigEntry<S> newSingleInstance(S var1, int var2, Runnable var3);

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.field_22790 - 30) / 25);
        this.itemScrollBar.setMaxValue(Math.max(0, this.getValues().size() - this.configPerPage));
    }

    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    public void updateItemPos() {
        int i;
        int top = this.itemScrollBar.getValue();
        Collection<S> entries = this.getValues();
        for (i = 0; i < top && i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < entries.size(); ++i) {
            this.widgets.get(i).update(true, 30 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (super.method_25401(mouseX, mouseY, scrollY)) {
            return true;
        }
        this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (scrollY > 0.0 ? -1 : 1) * 2);
        this.updateItemPos();
        return true;
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.itemScrollBar.render(graphics, mouseX, mouseY, partialTicks, this.field_22789 - 18, 30, 8, this.field_22790 - 50, (this.configPerPage + this.itemScrollBar.getMaxValue()) * 25);
        if (this.itemScrollBar.isDragging()) {
            this.updateItemPos();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.method_25402(mouseX, mouseY, button);
        if (!b) {
            this.method_25395(null);
        }
        return b;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.itemScrollBar.setIsDragging(false);
        }
        return super.method_25406(mouseX, mouseY, button);
    }
}

